/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.listeners;

import com.aetherteam.aether.event.hooks.EntityHooks;
import com.aetherteam.aetherfabric.events.CancellableCallback;
import com.aetherteam.aetherfabric.events.EntityEvents;
import com.aetherteam.aetherfabric.events.ExperienceDropHelper;
import com.aetherteam.aetherfabric.events.LivingEntityEvents;
import com.aetherteam.aetherfabric.events.PlayerTickEvents;
import com.aetherteam.aetherfabric.events.ProjectileEvents;
import io.wispforest.accessories.api.events.OnDeathCallback;
import java.util.ArrayList;
import java.util.Optional;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2784;
import net.minecraft.class_3966;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class EntityListener {
    public static void listen() {
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> EntityListener.onEntityJoin(entity));
        EntityEvents.ENTITY_MOUNT.register(EntityListener::onMountEntity);
        PlayerTickEvents.AFTER.register(EntityListener::onRiderTick);
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> EntityListener.onInteractWithEntity(entity, player, hand, hitResult));
        ProjectileEvents.ON_IMPACT.register(EntityListener::onProjectileHitEntity);
        LivingEntityEvents.ON_SHIELD_BLOCK.register(EntityListener::onShieldBlock);
        EntityEvents.STRUCK_BY_LIGHTNING.register(EntityListener::onLightningStrike);
        LivingEntityEvents.ON_EXPERIENCE_DROP.register((entity, attackingPlayer, helper) -> EntityListener.onDropExperience(entity, helper));
        LivingEntityEvents.ON_EFFECT.register((entity, instance, result) -> EntityListener.onEffectApply(entity, instance));
        OnDeathCallback.EVENT.register((currentState, entity, capability, damageSource, droppedStacks) -> {
            ArrayList<class_1799> droppedStacksCopy = new ArrayList<class_1799>(droppedStacks);
            boolean recentlyHit = entity.field_6037;
            int looting = class_1890.method_8203((class_6880)entity.method_37908().method_30349().aetherFabric$holderOrThrow(class_1893.field_9110), (class_1309)entity);
            droppedStacks.clear();
            droppedStacks.addAll(EntityHooks.handleEntityAccessoryDrops(entity, droppedStacksCopy, recentlyHit, looting));
            return TriState.DEFAULT;
        });
    }

    public static void onEntityJoin(class_1297 entity) {
        EntityHooks.addGoals(entity);
    }

    public static void onMountEntity(class_1297 riderEntity, class_1297 mountEntity, boolean isDismounting, CancellableCallback callback) {
        callback.setCanceled(EntityHooks.dismountPrevention(riderEntity, mountEntity, isDismounting));
    }

    public static void onRiderTick(class_1657 player) {
        EntityHooks.launchMount(player);
    }

    public static class_1269 onInteractWithEntity(class_1297 targetEntity, class_1657 player, class_1268 interactionHand, @Nullable class_3966 hitResult) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (hitResult == null) {
            class_2784 border = player.method_37908().method_8621();
            class_238 bounds = player.method_5829().method_18804(targetEntity.method_19538()).method_1014(1.0);
            class_238 clampedBounds = class_238.method_54784((class_2338)border.method_61116(bounds.method_61125()), (class_2338)border.method_61116(bounds.method_61126()));
            hitResult = class_1675.method_18075((class_1297)player, (class_243)player.method_33571(), (class_243)targetEntity.method_19538(), (class_238)clampedBounds, entity -> entity == targetEntity, (double)(player.method_19538().method_1022(targetEntity.method_19538()) + 1.0));
        }
        class_243 position = hitResult != null ? hitResult.method_17784().method_1020(targetEntity.method_19538()) : targetEntity.method_19538();
        EntityHooks.skyrootBucketMilking(targetEntity, player, interactionHand);
        Optional<class_1269> result = EntityHooks.pickupBucketable(targetEntity, player, interactionHand);
        if (result.isEmpty()) {
            result = EntityHooks.interactWithArmorStand(targetEntity, player, itemStack, position, interactionHand);
        }
        return result.orElse(class_1269.field_5811);
    }

    public static void onProjectileHitEntity(class_1297 projectileEntity, class_239 rayTraceResult, CancellableCallback callback) {
        if (EntityHooks.preventEntityHooked(projectileEntity, rayTraceResult)) {
            callback.setCanceled(true);
        }
    }

    public static void onShieldBlock(class_1282 damageSource, CancellableCallback callback) {
        if (!callback.isCanceled()) {
            callback.setCanceled(EntityHooks.preventSliderShieldBlock(damageSource));
        }
    }

    public static void onLightningStrike(class_1297 entity, class_1538 lightningBolt, CancellableCallback callback) {
        if (EntityHooks.lightningHitKeys(entity) || EntityHooks.thunderCrystalHitItems(entity, lightningBolt)) {
            callback.setCanceled(true);
        }
    }

    public static void onDropExperience(class_1309 livingEntity, ExperienceDropHelper event) {
        int experience = event.getDroppedExperience();
        int newExperience = EntityHooks.modifyExperience(livingEntity, experience);
        event.setDroppedExperience(newExperience);
    }

    public static TriState onEffectApply(class_1309 livingEntity, class_1293 effectInstance) {
        if (EntityHooks.preventInebriation(livingEntity, effectInstance)) {
            return TriState.FALSE;
        }
        return null;
    }
}

